import os, sys
import argparse
import yaml
from configUtils import *

##################Global Variables########################
HTTP_CALL_CONFIG = "httpCallConfig.dat"
NETWORK_MANAGEMENT = "API Network Management"
NETWORK_MANAGEMENT_STATUS = "API Network Status"
TLS_CLIENT_PROFILES = "API TLS Client Profiles"
TLS_SERVER_PROFILES = "API TLS Server Profiles"
SIP_SERVER_PROFILES = "API SIP Server Profiles"
SIGNALING_INTERFACE = "API Signaling Interface"
MEDIA_INTERFACE = "API Media Interface"
SIP_ROUTING_PROFILE = "API Routing Profile"
SIP_SERVER_FLOWS = "API Server Flows"
SIP_SUBSCRIBER_FLOWS = "API Subscriber FLows"
FEATURE_CONTROL = "API Feature Control"
APPLICATION_RULE = "API Application Rule"
END_POINT_POLICY = "API End Point Policy Group"
REVERSE_PROXY_RELAY = "API Reverse Proxy Relays"
CERTIFICATES = "API Certificates"
LOAD_MONITORING_PROFILE = "API Load Monitoring"
TURN_STUN_PROFILE = "API Turn Stun Profile"
TURN_STUN_RELAY = "API Turn Stun Relay"

def network_management():
    try:
        config_data = APIUtilities.file_utils(NETWORK_MANAGEMENT)
        return APIUtilities.return_result(config_data, APIDefs.NETWORK_MANAGEMENT.value, "networkId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def network_management_status():
    try:
        config_data = APIUtilities.file_utils(NETWORK_MANAGEMENT_STATUS)
        for data in config_data :
            data_dict = yaml.safe_load(data)
            for k, v in data_dict.items():
                api_path = "/api/config/v1/network-management/interfaces/%s:%s" % (k, v)
                APIUtilities.send_request(api_path, "interfaceName", data_dict, True)
        
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
    
        
def certificates():
    try:
        config_data = APIUtilities.file_utils(CERTIFICATES)
        return APIUtilities.return_result(config_data, APIDefs.CERTIFICATES.value, "")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e

def tls_client_profiles():
    try:
        default_data = {"peerCrlList": [], "verificationDepth": 1, "renegotiationTimeInSeconds": 30,
                        "renegotationByteCount": 0}
        config_data = APIUtilities.file_utils(TLS_CLIENT_PROFILES)
        return APIUtilities.return_result(config_data, APIDefs.TLS_CLIENT_PROFILES.value, "profileId", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
        
def tls_server_profiles():
    try:
        config_data = APIUtilities.file_utils(TLS_SERVER_PROFILES)
        return APIUtilities.return_result(config_data, APIDefs.TLS_SERVER_PROFILES.value, "profileId")

    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e

def sip_server_profiles():
    try:
        config_data = APIUtilities.file_utils(SIP_SERVER_PROFILES)
        return APIUtilities.return_result(config_data, APIDefs.SIP_SERVER_PROFILES.value, "serverId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e

def feature_control():
    try:
        config_data = APIUtilities.file_utils(FEATURE_CONTROL)
        return APIUtilities.return_result(config_data, APIDefs.FEATURE_CONTROL.value, "")
    except yaml.YAMLError as e:
        print("YAML Error %s" %e)
        raise e

def signaling_interface():
    try:
        config_data = APIUtilities.file_utils(SIGNALING_INTERFACE)
        return APIUtilities.return_result(config_data, APIDefs.SIGNALING_INTERFACES.value, "signalingId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def media_interface():
    try:
        config_data = APIUtilities.file_utils(MEDIA_INTERFACE)
        return APIUtilities.return_result(config_data, APIDefs.MEDIA_INTERFACES.value, "mediaId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def sip_routing_profile():
    try:
        # Do not change the indentation
        default_data = "uriGroupId: 1\n " \
                       " timeOfDayId: 1\n " \
                       " outgoingTransport: TLS\n " \
                       " loadBalancing: ROUND_ROBIN\n" \
                       "  nextHopInDialog: false\n" \
                       "  "
        config_data = APIUtilities.file_utils(SIP_ROUTING_PROFILE)
        for i, data in enumerate(config_data):
            if "nextHopAddresses" in data:
                index = data.find("nextHopAddresses")
                data = data[:index] + default_data + data[index:]
                config_data[i] = data
        return APIUtilities.return_result(config_data, APIDefs.SIP_ROUTING_PROFILES.value, "profileId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def sip_server_flow():
    try:
        default_data = {}
        config_data = APIUtilities.file_utils(SIP_SERVER_FLOWS)
        return APIUtilities.return_result(config_data, APIDefs.SIP_SERVER_FLOWS.value, "priority", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e


def sip_subscriber_flow():
    try:
        config_data = APIUtilities.file_utils(SIP_SUBSCRIBER_FLOWS)
        return APIUtilities.return_result(config_data, APIDefs.SIP_SUBSCRIBER_FLOWS.value, "flowId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
        
def reverse_proxy_relays():
    try:
        print("In reverse proxy relay...")
        config_data = APIUtilities.file_utils(REVERSE_PROXY_RELAY)
        return APIUtilities.return_result(config_data, APIDefs.REVERSE_PROXY_RELAYS.value, "relayId")
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
        
def turn_stun_profile():
    try:
        default_data = {"fingerPrint": "false", "tcpRelay": "false", "dtls": "false",
                        "mediaLearning": "false", "alternateServer1": "", "alternateServer2": "", "alternateServer3": ""}
        config_data = APIUtilities.file_utils(TURN_STUN_PROFILE)
        return APIUtilities.return_result(config_data, APIDefs.TURN_STUN_PROFILES.value, "profileId", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" % e)
        raise e
        

def turn_stun_relay():
    config_data = APIUtilities.file_utils(TURN_STUN_RELAY)
    return APIUtilities.return_result(config_data, APIDefs.TURN_STUN_RELAYS.value, "turnStunProfileId")
        
def load_monitoring():
    default_data = {"serviceType": "TURN", "loadBalancerType": "INTERNAL"}
    print(default_data)
    config_data = APIUtilities.file_utils(LOAD_MONITORING_PROFILE)
    print(config_data)
    return APIUtilities.return_result(config_data, APIDefs.LOAD_MONITORING_PROFILES.value, "profileId", default_data)
        
def application_rule():
    try:
        config_data = APIUtilities.file_utils(APPLICATION_RULE)
        return APIUtilities.return_result(config_data, APIDefs.APPLICATION_RULE.value,"ruleId")
    except yaml.YAMLError as e:
        print("YAML Error %s" %e)
        raise e

def end_point_policy_group():
    try:
        default_data = {"mediaRuleId": 1, "signalingRuleId": 1}
        config_data = APIUtilities.file_utils(END_POINT_POLICY)
        print(config_data)
        return APIUtilities.return_result(config_data, APIDefs.END_POINT_POLICY.value,"policyId", default_data)
    except yaml.YAMLError as e:
        print("YAML Error %s" %e)
        raise e

def post_all():
    print("entered POST all")
    APIUtilities.getToken(APIDefs.API_TOKEN.value)
    
    APIUtilities.check_id(network_management(), "NETWORK_MANAGEMENT")
    APIUtilities.create_map(APIDefs.NETWORK_MANAGEMENT.value, APIUtilities.get_request(APIDefs.NETWORK_MANAGEMENT.value))
    
    print("---------------------NETWORK_MANAGEMENT ADDED--------------------------")
    
    APIUtilities.check_id(feature_control(), "FEATURE_CONTROL")
    
    print("---------------------FEATURE_CONTROL ADDED--------------------------")
    
    network_management_status()
    
    APIUtilities.check_id(certificates(), "CERTIFICATES")
    
    print("---------------------CERTIFICATES ADDED--------------------------")
    
    APIUtilities.check_id(tls_client_profiles(), "TLS_CLIENT_PROFILES")
    APIUtilities.create_map(APIDefs.TLS_CLIENT_PROFILES.value, APIUtilities.get_request(APIDefs.TLS_CLIENT_PROFILES.value))
    
    print("---------------------TLS_CLIENT_PROFILES ADDED--------------------------")
    
    APIUtilities.check_id(tls_server_profiles(), "TLS_SERVER_PROFILES")
    APIUtilities.create_map(APIDefs.TLS_SERVER_PROFILES.value, APIUtilities.get_request(APIDefs.TLS_SERVER_PROFILES.value))
    
    print("---------------------TLS_SERVER_PROFILES ADDED--------------------------")
   
    APIUtilities.check_id(reverse_proxy_profile(), "REVERSE_PROXY_PROFILES")
    APIUtilities.create_map(APIDefs.REVERSE_PROXY_PROFILES.value, APIUtilities.get_request(APIDefs.REVERSE_PROXY_PROFILES.value))
    
    APIUtilities.check_id(reverse_proxy_relays(), "REVERSE_PROXY_RELAYS")
    
    print("---------------------REVERSE_PROXY_RELAY ADDED--------------------------")
   
    
    APIUtilities.check_id(signaling_interface(), "SIGNALING_INTERFACES")
    APIUtilities.create_map(APIDefs.SIGNALING_INTERFACES.value, APIUtilities.get_request(APIDefs.SIGNALING_INTERFACES.value))
    
    print("---------------------SIGNALING_INTERFACE ADDED--------------------------")
    
    APIUtilities.check_id(media_interface(), "MEDIA_INTERFACES")
    APIUtilities.create_map(APIDefs.MEDIA_INTERFACES.value, APIUtilities.get_request(APIDefs.MEDIA_INTERFACES.value))
    print(media_interface_map)
    
    print("---------------------MEDIA INTERFACES ADDED--------------------------")
    
    APIUtilities.check_id(application_rule(),"APPLICATION_RULE")
    APIUtilities.create_map(APIDefs.APPLICATION_RULE.value, APIUtilities.get_request(APIDefs.APPLICATION_RULE.value))
    print(application_rule_map)
    
    print("---------------------APPLICATION_RULE ADDED--------------------------")
    
    APIUtilities.check_id(end_point_policy_group(), "END_POINT_POLICY")
    APIUtilities.create_map(APIDefs.END_POINT_POLICY.value, APIUtilities.get_request(APIDefs.END_POINT_POLICY.value))
    print(endpoint_policy_map)
    
    print("---------------------END_POINT_POLICY ADDED--------------------------")
    
    APIUtilities.check_id(load_monitoring(), "LOAD_MONITORING_PROFILES")
    
    print("---------------------LOAD MONITORING ADDED--------------------------")
    
    APIUtilities.check_id(sip_server_profiles(), "SIP_SERVER_PROFILES")
    APIUtilities.create_map(APIDefs.SIP_SERVER_PROFILES.value, APIUtilities.get_request(APIDefs.SIP_SERVER_PROFILES.value))
    
    print("---------------------SIP SERVER PROFILES ADDED--------------------------")
    
    APIUtilities.check_id(sip_routing_profile(), "SIP_ROUTING_PROFILES")
    APIUtilities.create_map(APIDefs.SIP_ROUTING_PROFILES.value, APIUtilities.get_request(APIDefs.SIP_ROUTING_PROFILES.value))
    
    print("---------------------SIP ROUTING PROFILES ADDED--------------------------")
    
    APIUtilities.check_id(sip_server_flow(), "SIP_SERVER_FLOWS")
    
    print("---------------------SIP SERVER FLOWS ADDED--------------------------")
    
    APIUtilities.check_id(turn_stun_profile(), "TURN_STUN_PROFILES")
    APIUtilities.create_map(APIDefs.TURN_STUN_PROFILES.value, APIUtilities.get_request(APIDefs.TURN_STUN_PROFILES.value))
    
    print("---------------------Turn Stun Profiles Added ADDED--------------------------")
    
    APIUtilities.check_id(turn_stun_relay(), "TURN_STUN_RELAYS")

    print("---------------------TURN RELAY ADDED--------------------------")
    print("API add completed")


def delete_resource(apiname, id):
    APIUtilities.delete_request(apiname, id)


if __name__ == '__main__':
    try:
        obj = APIUtilities(HTTP_CALL_CONFIG)
        parser = argparse.ArgumentParser()

        parser.add_argument("HTTPMETHOD", choices={"POST", "DELETE"}, type=str)
        parser.add_argument("--apiname", type=str, choices=list(APIDefs.__members__),
                            help="Delete a configuration for HTTP call flow for given API, only used with DELETE")
        parser.add_argument("--id", type=int, help="The ID to be deleted, required only for DELETE")

        args = (parser.parse_args())

        if args.HTTPMETHOD == "POST":
            post_all()
        if args.HTTPMETHOD == "DELETE":
            if args.apiname is None or args.id is None:
                print("--apiname and --id required for DELETE")
            delete_resource(args.apiname, args.id)

    except Exception as e:
        exc_type, exc_obj, exc_tb = sys.exc_info()
        fname = os.path.split(exc_tb.tb_frame.f_code.co_filename)[1]
        print("Error in main %s line_no %s" % (e,exc_tb.tb_lineno) )
        APIUtilities.bulk_delete()

